//----------------------------------------------------------------------------//
//- CapAbschlussdaten.pas ----------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
//  Druckt die Abschlussdaten der Brse                                       //
//----------------------------------------------------------------------------//

unit CapAbschlussdaten;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, CapBaseReport, QuickRpt, QRCtrls, ExtCtrls, CaoBoersenInfo,
  CaoArtikelListe, CaoFormat;

//------------------------------------------------------------------------------

type
  TCaQrpAbschlussdaten = class(TCaQrpBaseReport)
    m_QrBndDaten                     : TQRStringsBand;
    m_LblSchlussabrechnung           : TQRLabel;
    m_QrBndAnbieterData              : TQRStringsBand;
    m_QrLblAnbieterName              : TQRLabel;
    m_QrBndArtikelData               : TQRStringsBand;
    m_QrLblArtikelnummer             : TQRLabel;
    m_QrLblArtikel	             : TQRLabel;
    m_QrLblPreis                     : TQRLabel;
    m_QrLblArtikelNummerData         : TQRLabel;
    m_QrLblArtikelTitelData          : TQRLabel;
    m_QrLblPreisData                 : TQRLabel;
    m_LblAbrechnungFuer              : TQRLabel;
    m_QrBndTotal                     : TQRStringsBand;
    m_LblUmsatz                      : TQRLabel;
    m_LblUmsatzData                  : TQRLabel;
    m_QrLblTotalUmsatz               : TQRLabel;
    m_QrLblTotalUmsatzData           : TQRLabel;
    m_QrLblGewinn                    : TQRLabel;
    m_QrLblGewinnData                : TQRLabel;
    m_QrBndBoersenDaten              : TQRChildBand;
    m_QrLblBoersenTitel              : TQRLabel;
    m_QrLblStart                     : TQRLabel;
    m_QrLblEnde                      : TQRLabel;
    m_QrLblAbgabenProzent            : TQRLabel;
    m_QrLblAbgabenBetrag             : TQRLabel;
    m_QrLblEingBoersenTitel          : TQRLabel;
    m_QrLblEingStart                 : TQRLabel;
    m_QrLblEingEnde                  : TQRLabel;
    m_QrLblEingAbgabenProzent        : TQRLabel;
    m_QrLblEingAbgabenBetrag         : TQRLabel;
    m_QrLblBoersenDaten              : TQRLabel;
    m_QrBndStatistik                 : TQRChildBand;
    m_QrLblStatistik                 : TQRLabel;
    m_QrLblUmsatz                    : TQRLabel;
    m_QrLblTotalGewinn               : TQRLabel;
    m_QrLblTotalArtikel              : TQRLabel;
    m_QrLblVerkaufteArtikel          : TQRLabel;
    m_QrLblNichtVerkaufteArtikel     : TQRLabel;
    m_QrLblUmsatzData                : TQRLabel;
    m_QrLblTotalGewinnData           : TQRLabel;
    m_QrLblTotalArtikelData          : TQRLabel;
    m_QrLblVerkaufteArtikelData      : TQRLabel;
    m_QrLblNichtVerkaufteArtikelData : TQRLabel;

    //--------------------------------------------------------------------------

    procedure QrBndDatenBeforePrint(Sender       : TQRCustomBand;
                                  var PrintBand  : Boolean);
    procedure QuickRepBeforePrint(Sender         : TCustomQuickRep;
                                  var PrintReport: Boolean);
    procedure QrBndAnbieterDataBeforePrint(Sender: TQRCustomBand;
                                  var PrintBand  : Boolean);
    procedure QrBndArtikelDataBeforePrint(Sender : TQRCustomBand;
                                  var PrintBand  : Boolean);
    procedure QuickRepAfterPrint(Sender: TObject);
    procedure QrBndTotalBeforePrint(Sender: TQRCustomBand;
                                  var PrintBand: Boolean);

  //----------------------------------------------------------------------------

  private
    m_obBoersenInfo      : TCaoBoersenInfo;
    m_obArtikelListe,
    m_obTempArtikelListe : TCaoArtikelListe;
    m_obFormat           : TCaoFormat;

  //----------------------------------------------------------------------------

  public
    procedure Preview(obBoersenInfo : TCaoBoersenInfo;
                      obArtikelListe: TCaoArtikelListe); reintroduce;
    procedure Print  (obBoersenInfo : TCaoBoersenInfo;
                      obArtikelListe: TCaoArtikelListe); reintroduce;
  //----------------------------------------------------------------------------

  end; // TCaQrpAbschlussdaten

//------------------------------------------------------------------------------

var
  CaQrpAbschlussdaten: TCaQrpAbschlussdaten;

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

uses
  CaoPersonenListe;

//------------------------------------------------------------------------------

{$R *.dfm}

//------------------------------------------------------------------------------

procedure TCaQrpAbschlussdaten.Preview(obBoersenInfo : TCaoBoersenInfo;
                                       obArtikelListe: TCaoArtikelListe);
begin
  m_obBoersenInfo  := obBoersenInfo;
  m_obArtikelListe := obArtikelListe;
  inherited Preview(obBoersenInfo);
end; // TCaQrpAbschlussdaten.Preview

//------------------------------------------------------------------------------

procedure TCaQrpAbschlussdaten.Print(obBoersenInfo : TCaoBoersenInfo;
                                     obArtikelListe: TCaoArtikelListe);
begin
  m_obBoersenInfo  := obBoersenInfo;
  m_obArtikelListe := obArtikelListe;
  inherited Print(obBoersenInfo);
end; // TCaQrpAbschlussdaten.Print

//------------------------------------------------------------------------------

procedure TCaQrpAbschlussdaten.QrBndDatenBeforePrint(Sender: TQRCustomBand;
                                                     var PrintBand: Boolean);
var
  dGewinn: Double;
begin
  inherited;
  dGewinn := m_obArtikelListe.GetGewinnFromBetrag(m_obBoersenInfo.dAbgabeBetrag) +
             m_obArtikelListe.GetGewinnFromProzent(m_obBoersenInfo.dAbgabeProzent);
  m_QrLblEingBoersenTitel.Caption   := m_obBoersenInfo.sTitel;
  m_QrLblEingStart.Caption          := DateToStr(m_obBoersenInfo.dtBoersenDatum);
  m_QrLblEingEnde.Caption           := DateToStr(Now);
  m_QrLblEingAbgabenProzent.Caption := FloatToStr(m_obBoersenInfo.dAbgabeProzent);
  m_QrLblEingAbgabenBetrag.Caption  :=
                       m_obFormat.FormatCurrency(m_obBoersenInfo.dAbgabeBetrag);
  m_QrLblUmsatzData.Caption         :=
                       m_obFormat.FormatCurrency(m_obArtikelListe.GetGewinn);
  m_QrLblTotalGewinnData.Caption    :=
                       m_obFormat.FormatCurrency(dGewinn);
  m_QrLblTotalArtikelData.Caption   :=
                      IntToStr(m_obArtikelListe.Count);
  m_QrLblVerkaufteArtikelData.Caption :=
                      IntToStr(m_obArtikelListe.GetTotalVerkauft);
  m_QrLblNichtVerkaufteArtikelData.Caption :=
                      IntToStr(m_obArtikelListe.GetTotalNichtVerkauft);
end; // TCaQrpAbschlussdaten.QrBndDatenBeforePrint

//------------------------------------------------------------------------------

procedure TCaQrpAbschlussdaten.QuickRepBeforePrint(Sender: TCustomQuickRep;
                                                   var PrintReport: Boolean);
var
  iIndex,
  iTempAnbieterNr   : Integer;
  obTempAnbieter    : TCaoPersonen;
begin
  inherited;
  m_obFormat := TCaoFormat.Create;
  // Eine Temporre ArtikelListe anlegen, die in sortiert werden kann
  m_obTempArtikelListe := TCaoArtikelListe.Create;
  // Kopieren der ArtikelListe in die Temporre ArtikelListe
  m_obTempArtikelListe.CopyArtikelListe(m_obArtikelListe);
  // Sortieren der ArtikelListe nach der Anbieternummer
  m_obTempArtikelListe.SortByAnbieterNr;

  // Die Bnder leeren
  m_QrBndAnbieterData.Items.Clear;
  iTempAnbieterNr := -1;
  for iIndex := 0 to m_obTempArtikelListe.Count -1 do begin
    obTempAnbieter := TCaoPersonen(m_obTempArtikelListe.Items[iIndex].pAnbieter);
    if obTempAnbieter.iPersonenNummer
       <> iTempAnbieterNr then begin
      iTempAnbieterNr := obTempAnbieter.iPersonenNummer; 
      m_QrBndAnbieterData.Items.Add(IntToStr(iIndex));
    end; // if
  end; // for 
end; // TCaQrpAbschlussdaten.QuickRepBeforePrint

//------------------------------------------------------------------------------

procedure TCaQrpAbschlussdaten.QrBndAnbieterDataBeforePrint(Sender: TQRCustomBand;
                                                            var PrintBand: Boolean);
var
  iTempIndex     : Integer;
  obTempAnbieter : TCaoPersonen;
  pTempPers      : Pointer; 
begin
  inherited;
  iTempIndex     := StrToInt(m_QrBndAnbieterData.Item);
  obTempAnbieter := TCaoPersonen(m_obTempArtikelListe.Items[iTempIndex].pAnbieter);
  pTempPers      := m_obTempArtikelListe.Items[iTempIndex].pAnbieter;

  m_QrLblAnbieterName.Caption := obTempAnbieter.sInitialen + ' (' +
                                 obTempAnbieter.sVorname + ' ' +
                                 obTempAnbieter.sName + ')';
  m_QrBndArtikelData.Items.Clear;
  repeat
    m_QrBndArtikelData.Items.Add(IntToStr(iTempIndex));
    Inc(iTempIndex);
    // Wenn iTempIndex die Grsse der Artikelliste bersteigt, muss die
    // Schleife verlassen werden
    if (iTempIndex >= m_obTempArtikelListe.Count) then begin
      Break;
    end; // if
  until (m_obTempArtikelListe.Items[iTempIndex].pAnbieter <> pTempPers);
  // Am Schluss jeder ArtikelListe muss der Umsatz des Anbieters
  // angezeigt werden
  m_QrBndTotal.Items.Clear;
  m_QrBndTotal.Items.Add(IntToStr(Integer(pTempPers)));
end; // TCaQrpAbschlussdaten.QrBndAnbieterDataBeforePrint

//------------------------------------------------------------------------------

procedure TCaQrpAbschlussdaten.QrBndArtikelDataBeforePrint(Sender: TQRCustomBand;
                                                           var PrintBand: Boolean);
var
  iTempIndex: Integer;
begin
  inherited;
  iTempIndex := StrToInt(m_QrBndArtikelData.Item);
  m_QrLblArtikelNummerData.Caption :=
    m_obFormat.FormatBarCode(m_obTempArtikelListe.Items[iTempIndex].iArtikelNummer);
  m_QrLblArtikelTitelData.Caption  :=
    m_obTempArtikelListe.Items[iTempIndex].sBeschreibung;
  m_QrLblPreisData.Caption         :=
    m_obFormat.FormatCurrency(m_obTempArtikelListe.Items[iTempIndex].dPreis);
  if m_obTempArtikelListe.Items[iTempIndex].fVerkauft then begin
    m_LblUmsatzData.Caption        :=
      m_obFormat.FormatCurrency(m_obTempArtikelListe.Items[iTempIndex].dPreis);
  end // if
  else begin
    m_LblUmsatzData.Caption := '0.00';
  end; // else
end; // TCaQrpAbschlussdaten.QrBndArtikelDataBeforePrint

//------------------------------------------------------------------------------

procedure TCaQrpAbschlussdaten.QuickRepAfterPrint(Sender: TObject);
begin
  inherited;
  m_obTempArtikelListe.Free(True);
  m_obFormat.Free;
end; // TCaQrpAbschlussdaten.QuickRepAfterPrint

//------------------------------------------------------------------------------

procedure TCaQrpAbschlussdaten.QrBndTotalBeforePrint(Sender: TQRCustomBand;
                                                     var PrintBand: Boolean);
var
  dGewinn,
  dUmsatz: Double;
begin
  inherited;
  dUmsatz := m_obTempArtikelListe.GetGewinn(Pointer(StrToInt(m_QrBndTotal.Item)));
  m_QrLblTotalUmsatzData.Caption := m_obFormat.FormatCurrency(dUmsatz);
  dGewinn := dUmsatz - (dUmsatz * (m_obBoersenInfo.dAbgabeProzent / 100));
  dGewinn := dGewinn - m_obBoersenInfo.dAbgabeBetrag; 
  m_QrLblGewinnData.Caption := m_obFormat.FormatCurrency(dGewinn);
end; // TCaQrpAbschlussdaten.QrBndTotalBeforePrint

//------------------------------------------------------------------------------

end. // CapAbschlussdaten
